/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import noppes.npcs.NBTTags;
import noppes.npcs.util.ValueUtil;

public class SpawnData
extends WeightedRandom.Item {
    public List<String> biomes = new ArrayList<String>();
    public NBTTagCompound compoundEntity = new NBTTagCompound();
    public int id = -1;
    public boolean liquid = false;
    public boolean canSeeSummon = true;
    public String name = "";
    public int type = 0;
    public int group = 4;
    public int range = 8;
    public int maxNearPlayer = 10;

    public SpawnData() {
        super(10);
    }

    public void readNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("SpawnId");
        this.name = compound.func_74779_i("SpawnName");
        this.field_76292_a = ValueUtil.correctInt(compound.func_74762_e("SpawnWeight"), 1, 100);
        this.biomes = NBTTags.getStringList(compound.func_150295_c("SpawnBiomes", 10));
        this.compoundEntity = compound.func_74775_l("SpawnCompound1");
        this.type = compound.func_74762_e("SpawnType");
        if (compound.func_150297_b("MaxInGroup", 3)) {
            this.group = compound.func_74762_e("MaxInGroup");
        }
        if (compound.func_150297_b("GroupInRange", 3)) {
            this.range = compound.func_74762_e("GroupInRange");
        }
        if (compound.func_150297_b("MaximumNearPlayer", 3)) {
            this.maxNearPlayer = compound.func_74762_e("MaximumNearPlayer");
        }
        this.canSeeSummon = compound.func_74767_n("PlayerCanSeeSummon");
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("SpawnId", this.id);
        compound.func_74778_a("SpawnName", this.name);
        compound.func_74768_a("SpawnWeight", this.field_76292_a);
        compound.func_74782_a("SpawnBiomes", (NBTBase)NBTTags.nbtStringList(this.biomes));
        compound.func_74782_a("SpawnCompound1", (NBTBase)this.compoundEntity);
        compound.func_74768_a("SpawnType", this.type);
        compound.func_74768_a("MaxInGroup", this.group);
        compound.func_74768_a("GroupInRange", this.range);
        compound.func_74768_a("MaximumNearPlayer", this.maxNearPlayer);
        compound.func_74757_a("PlayerCanSeeSummon", this.canSeeSummon);
        return compound;
    }
}

